#ifndef CE2_C2_Error_H
#define CE2_C2_Error_H

/*
* All the includes that are needed for code using this module to
* compile correctly should be #included here.
*/

#include "CryptoEngine2.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*
*  Object name     :  CE2_C2_Error.h
*  State           :  %state%
*  Creation date   :  27.03.2007
*  Last modified   :  %modify_time%
*/
/** @file
* \brief contains error codes for C2 functions.
*
*  \version CE2_C2_Error.h#1:cinc:1
*  \author Yermalayeu Ihar
* \remarks Copyright (C) 2007 by Discretix Technologies Ltd. All rights reserved.
*/

#define C2_ERROR_IDX 0x10UL

  /* C2 module on the CE2 layer base address - 0x00F01000 */
#define CE2_C2_MODULE_ERROR_BASE (CE2_ERROR_BASE + \
  (CE2_ERROR_LAYER_RANGE * CE2_LAYER_ERROR_IDX) + \
  (CE2_ERROR_MODULE_RANGE * C2_ERROR_IDX ) )  

  /* C2 module on the LLF layer base address -  0x00F11000 */
#define LLF_C2_MODULE_ERROR_BASE (CE2_ERROR_BASE + \
  (CE2_ERROR_LAYER_RANGE * LLF_LAYER_ERROR_IDX) + \
  (CE2_ERROR_MODULE_RANGE * C2_ERROR_IDX ) )   

  /* C2 module on the LLFCD layer base address - 0x00F21000 */
#define LLFCD_C2_MODULE_ERROR_BASE (CE2_ERROR_BASE + \
  (CE2_ERROR_LAYER_RANGE * LLFCD_LAYER_ERROR_IDX) + \
  (CE2_ERROR_MODULE_RANGE * C2_ERROR_IDX ) )

  /* CE2_C2() error codes */
#define CRYS_C2_CIPHER_INVALID_USER_CONTEXT_POINTER_ERROR (CE2_C2_MODULE_ERROR_BASE + 0x01)       
#define CRYS_C2_CIPHER_ILLEGAL_OPERATION_MODE_ERROR (CE2_C2_MODULE_ERROR_BASE + 0x02)       
#define CRYS_C2_CIPHER_INVALID_KEY_POINTER_ERROR (CE2_C2_MODULE_ERROR_BASE + 0x03)       
#define CRYS_C2_CIPHER_INVALID_ENCRYPT_MODE_ERROR (CE2_C2_MODULE_ERROR_BASE + 0x04)       
#define CRYS_C2_CIPHER_DATA_IN_POINTER_INVALID_ERROR (CE2_C2_MODULE_ERROR_BASE + 0x05)       
#define CRYS_C2_CIPHER_DATA_OUT_POINTER_INVALID_ERROR (CE2_C2_MODULE_ERROR_BASE + 0x06)       
#define CRYS_C2_CIPHER_DATA_SIZE_ILLEGAL (CE2_C2_MODULE_ERROR_BASE + 0x07)       
#define CRYS_C2_CIPHER_DATA_OUT_DATA_IN_OVERLLAP_ERROR (CE2_C2_MODULE_ERROR_BASE + 0x08)       

#ifdef __cplusplus
}
#endif

#endif /* End of CE2_C2_Error_H */
